import pandas as pd  
import scipy.stats as stats  
import pickle
from decision_company import read_csv_file, access_dataframe_loc, access_dataframe_loc, logical_and, check_elements_in_list, f_oneway

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create a new column to identify younger customers (aged 18-35)  
age_column = credit_customers['age'] 
credit_customers['young_customer'] = logical_and(age_column >= 18, age_column <= 35)  
  
# Filter customers with good credit history  
credit_history_column = credit_customers['credit_history']  
good_credit_history = check_elements_in_list(credit_history_column, ['existing paid', 'no credits/all paid', 'all paid'])  
  
# Create groups based on young_customer and good_credit_history  
group1 = access_dataframe_loc(credit_customers, logical_and(credit_customers['young_customer'], good_credit_history), 'credit_amount')  
group2 = access_dataframe_loc(credit_customers, logical_and(~credit_customers['young_customer'], good_credit_history), 'credit_amount')  
group3 = access_dataframe_loc(credit_customers, logical_and(credit_customers['young_customer'], ~good_credit_history), 'credit_amount')  
group4 = access_dataframe_loc(credit_customers, logical_and(~credit_customers['young_customer'], ~good_credit_history), 'credit_amount')  
  
# Perform ANOVA test  
f_statistic, p_value = f_oneway(group1, group2, group3, group4)  
  
print(f"F-statistic: {f_statistic}, P-value: {p_value}")
pickle.dump(f_statistic,open("./ref_result/f_statistic.pkl","wb"))
pickle.dump(p_value,open("./ref_result/p_value.pkl","wb"))